--[[---------------------------------------------------------------------------
	Chocolatier Two: Market Haggling
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local insetX = 110
local insetY = 50
local windowX = ui.xOffset + insetX + ui.charW
local windowY = ui.yOffset + insetY
local windowW = 404
local windowH = 370

local color = MarketColor

-- Determine type of haggling
local self = gDialogTable.market
local type = "market"
if not self then
	self = gDialogTable.shop
	type = "shop"
	color = ShopColor
end

local char = gDialogTable.char or self.characters[1]

-- Choose character intro speech at random
local intro = LabelString(type.."_intro_"..tostring(bsgRandom(1,10)))

-- Choose response lines at random without duplicates
local lines = {}
local used = {}
local count = 0
while count < 4 do
	local use = bsgRandom(1,10)
	if not used[use] then
		count = count + 1
		lines[count] = type.."_"..tostring(use)
		used[use] = true
	end
end

-------------------------------------------------------------------------------
-- Haggle response

local action = "cancel"
function DoHaggle(choice)
	-- Characters bristle a bit when haggling...
	-- but never become angry unless they're already angry (in which case they're not haggling?)
	if not char:IsAngry() then
		char:SetMood(char.mood - LCharacter.kHaggleDelta)
		if char:IsAngry() then char:SetMood(LCharacter.kAngry + 1) end
	end

	-- Determine the haggle outcome
	action = self:ComputeHaggle(char)
	
	-- Hide haggle options
	EnableWindow("option_1", false)
	EnableWindow("option_2", false)
	EnableWindow("option_3", false)
	EnableWindow("option_4", false)
	EnableWindow("cancel", false)
	
	-- Show haggle response
	EnableWindow("player_choice", true)
	EnableWindow("response", true)
	EnableWindow("ok", true)
	EnableWindow("intro", false)
	
	local response = type.."_"..action.."_"..bsgRandom(1,10)
	SetLabel("response", GetString(response, {vendor=GetString(char.name), port=GetString(gSim.port.name), market=GetString(self.name) } ))
	SetLabel("player_text", GetString(lines[choice]))
end

-------------------------------------------------------------------------------

local buttonX = (windowW - ui.devButtonW) / 2
local buttonY = windowH - 40
local w = windowW

MakeDialog
{
	Frame
	{
		x=windowX,y=windowY,w=windowW,h=windowH,fit=true, color=color,

		TextButton { x=buttonX,y=buttonY, name="cancel", close=true, label="cancel" },
		TextButton { x=buttonX,y=buttonY, name="ok", label="ok", command=function() CloseWindow(action) end },
		
		AppendStyle { font=dialogFont },

		Text { x=kCenter,y=0,w=kMax,h=60, name="intro", label=intro },
		Bitmap { y=4,x=5, image="control/haggle_field", name="player_choice",
			Text { x=18,y=5,w=357,h=50, graphics={}, label="", name="player_text" } },
		
		Bitmap { y=66,x=5, image="control/haggle_field", name="option_1",
			Button { x=18,y=5,w=357,h=50, graphics={}, command=function() DoHaggle(1) end,
				-- Q&D Rollover highlights
				SelectLayer(2),
				Rectangle { x=0,y=0,w=kMax,h=kMax, color=WhiteColor, alpha = .25 },	
				SelectLayer(kAllLayers),
				Text { label=lines[1], x=0,y=0,w=kMax,h=kMax, } } },
		Bitmap { y=132,x=5, image="control/haggle_field", name="option_2",
			Button { x=18,y=5,w=357,h=50, graphics={}, command=function() DoHaggle(2) end,
				-- Q&D Rollover highlights
				SelectLayer(2),
				Rectangle { x=0,y=0,w=kMax,h=kMax, color=WhiteColor, alpha = .25 },	
				SelectLayer(kAllLayers),
				Text { label=lines[2], x=0,y=0,w=kMax,h=kMax, } } },
		Bitmap { y=198,x=5, image="control/haggle_field", name="option_3",
			Button { x=18,y=5,w=357,h=50, graphics={}, command=function() DoHaggle(3) end,
				-- Q&D Rollover highlights
				SelectLayer(2),
				Rectangle { x=0,y=0,w=kMax,h=kMax, color=WhiteColor, alpha = .25 },	
				SelectLayer(kAllLayers),
				Text { label=lines[3], x=0,y=0,w=kMax,h=kMax, } } },
		Bitmap { y=262,x=5, image="control/haggle_field", name="option_4",
			Button { x=18,y=5,w=357,h=50, graphics={}, command=function() DoHaggle(4) end,
				-- Q&D Rollover highlights
				SelectLayer(2),
				Rectangle { x=0,y=0,w=kMax,h=kMax, color=WhiteColor, alpha = .25 },	
				SelectLayer(kAllLayers),
				Text { label=lines[4], x=0,y=0,w=kMax,h=kMax, } } },
		
		Text { x=0,y=50,w=kMax,h=230, name="response", label="", font=dialogFont, },
	},
--	char:Visual(charX, ui.yOffset, charNameFontDark),
}

EnableWindow("ok", false)
EnableWindow("response", false)
EnableWindow("player_choice", false)
